-- Heavily modified from default.
local iPN = ...
assert(iPN,"[ScreenSelectMusic decorations/InfoPane.lua] Can't display player info without a PlayerNumber!")

local posMod = iPN == PLAYER_1 and -1 or 1
local paneWidth = (_screen.w - 284) / 2
local lolHeight = _screen.h / 3

-- Try and keep from re-updating what doesn't need to be updated.
local curTarget = false
local pnProfile = PROFILEMAN:GetProfile(iPN)

local t = Def.ActorFrame {
	CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set"),
	CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set"),
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set"),
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set"),
	--CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
	
	Def.ActorFrame{	
		-- CurrentSongChangedMessageCommand=function(self)
			-- self:visible(GAMESTATE:GetCurrentSong() and true or false)
		-- end,
		Name="Chartstuff",
		SetCommand=function(self)
			local target = GAMESTATE:GetCurrentSteps(iPN)
			if curTarget ~= target then
				curTarget = target
				self:playcommand("SetIP")
			end
		end,
		
		-- A dark quad.
		Def.Quad {
			InitCommand=cmd(zoomto,paneWidth,lolHeight;diffuse,LocalBlueColor(0);horizalign,iPN==PLAYER_1 and right or left;vertalign,top)
		},
		
		-- Backings for headers.
		Def.Quad {
			OnCommand=function(self)
				self:vertalign(top):zoomto(paneWidth,14):horizalign(iPN==PLAYER_1 and right or left):vertalign(top):diffuse(LocalBlueColor(0.25))
			end,
		},
		-- Def.Quad {
			-- OnCommand=function(self)
				-- self:vertalign(top):y(34):zoomto(paneWidth,14):horizalign(iPN==PLAYER_1 and right or left):vertalign(top):diffuse(LocalBlueColor(0.25))
			-- end,
		-- },
		Def.Quad {
			OnCommand=function(self)
				self:vertalign(top):y(44):zoomto(paneWidth,14):horizalign(iPN==PLAYER_1 and right or left):vertalign(top):diffuse(ColorDarkTone(PlayerColor(iPN)))
			end,
		},
		
		-- Small black strip to "highlight" the player color strip below.
		-- Def.Quad {
			-- InitCommand=cmd(zoomto,26,lolHeight;diffuse,Color.Black;horizalign,iPN==PLAYER_1 and right or left;vertalign,top)
		-- },
		
		-- Chart title header.
		Def.BitmapText {
			Font = "Common Small",
			Text = THEME:GetString("ScreenSelectMusic", "CurChart"),
			OnCommand=function(self)
				self:xy((paneWidth - 3) * posMod, 7):horizalign(iPN==PLAYER_1 and left or right):zoom(0.4):strokecolor(Color.Black)
			end
		},
		
		-- Chart title if available.
		Def.BitmapText {
			Font = "Common Normal",
			OnCommand=function(self)
				self:xy((paneWidth - 8) * posMod,23):strokecolor(Color.Black):zoom(0.4):maxwidth(paneWidth / 0.5)
				self:horizalign(iPN==PLAYER_1 and left or right)
			end,
			SetIPCommand=function(self)
				local steps = GAMESTATE:GetCurrentSteps(iPN)
				if not steps or not GAMESTATE:GetCurrentSong() then self:visible(false) return end --failsafe
				
				self:visible(true)
				self:settext(steps:Title()):diffuse(CustomDifficultyToColor(steps:GetDifficulty(), steps:GetChartName()))
			end
		},
		
		-- Chart author.
		Def.BitmapText {
			Font = "Common Normal",
			OnCommand=function(self)
				self:xy((paneWidth - 3) * posMod, 37):horizalign(iPN==PLAYER_1 and left or right):zoom(0.3):strokecolor(Color.Black):maxwidth(paneWidth / 0.32)
				--self:maxwidth(200)
			end,
			-- CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			-- CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set"),
			-- CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set"),
			-- CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set"),
			-- CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set"),
			-- CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
			SetIPCommand=function(self)
				local steps = curTarget
				if not steps or not GAMESTATE:GetCurrentSong() then self:visible(false) return end --failsafe
				local theText = steps:IsAutogen() and "(AUTOGEN) " .. steps:Author() or steps:Author()
				
				self:visible(true)
				self:settext("- " .. theText)
			end
		},
		
		-- PB header.
		Def.BitmapText {
			Font = "Common Small",
			Text = THEME:GetString("ScreenSelectMusic", "ChartPB"),
			OnCommand=function(self)
				self:xy((paneWidth - 3) * posMod, 50):horizalign(iPN==PLAYER_1 and left or right):zoom(0.4):strokecolor(Color.Black)
			end
		},
		-- Personal best.
		Def.BitmapText {
			Font = "Common Normal",
			Name = "TradScore",
			OnCommand=function(self)
				self:xy((paneWidth - 3) * posMod, 66):horizalign(iPN==PLAYER_1 and left or right):zoom(0.4):strokecolor(Color.Black):maxwidth(paneWidth / 0.32)
			end,
			
			SetIPCommand=function(self)
				local songOrCourse = GAMESTATE:GetCurrentSong()
				local target = curTarget
				if songOrCourse and target then
					self:visible(true)
					local highScoreList = pnProfile:GetHighScoreListIfExists(songOrCourse, target)
					local highScores = highScoreList and highScoreList:GetHighScores()
					
					if highScores and #highScores > 0 then
						local pScore = FormatPercentScore( highScores[1]:GetPercentDP() )
						local lScore = commify(highScores[1]:GetScore())
						
						self:settext(PREFSMAN:GetPreference("PercentageScoring") and pScore .. " [" .. lScore .. "]" or lScore .. " [" .. pScore .. "]")
					else
						self:settext("N/A")
					end
				else
					self:visible(false)
				end
			end,
		},
	},
	
	-- Player mod display!
	Def.BitmapText {
		Font = "Common Normal",
		OnCommand=function(self)
			self:strokecolor(Color.Outline):zoom(0.3):horizalign(iPN==PLAYER_1 and left or right):maxwidth((paneWidth - 12) / 0.3):xy((paneWidth - 8) * posMod,86)
			self:playcommand("CheckMods")
		end,
		CheckModsCommand=function(self)
			self:settext("Cur. mods: " .. GAMESTATE:GetPlayerState(iPN):GetPlayerOptionsString("ModsLevel_Current"))
		end,
		OptionsListStartMessageCommand=function(self) self:playcommand("CheckMods") end,
	}
}

return t
